
// Copyright (c) 2003 Sonic Foundry, Inc. and Sonic Foundry 
// Media Systems, Inc. Neither this code nor any portion 
// thereof maybe reproduced, altered,or otherwise changed, 
// distributed or copied,without the express written 
// permission of Sonic Foundry. 
// All rights reserved.

WM64LitePlayerArea.prototype = new PlayerArea();

function WM64LitePlayerArea(container, containingWindow, ID)
{
	this.m_debugLevel = SfDebug.Verbose;
//	this.m_debugLevel = SfDebug.Information;

	this.PlayerType = PlayerType.WM64Lite;
	this.IsSetupComplete = false;
	
	if (container && containingWindow && ID)
	{
		this.InitializeArea(container, containingWindow, ID);
		SfOnLoad.AddHandler(this.Container + ".DoOnLoad()", AreaNames.Global);
	}

	// can not call onload because of dependency between frames
	this.OnLoad = function()
	{
		// do nothing
	}
	
	this.SetupPlayer = function()
	{
		this.Debug("Setup Player called");

		this.evScriptHandler = new SfEventHandler("Player");
		this.evScriptHandler.MethodName = "LocalOnScriptEvent";
		this.evScriptHandler.Container = "PlayerAreaInstance";
		MainHelper.EventScript.AddHandler(this.evScriptHandler);

		this.evCommandHandler = new SfEventHandler("Player");
		this.evCommandHandler.MethodName = "LocalOnCommandEvent";
		this.evCommandHandler.Container = "PlayerAreaInstance";
		MainHelper.EventCommand.AddHandler(this.evCommandHandler);
		
		// need to force video load to kick things off if we were waiting for Live to start
		if ( MainHelper.Presentation.Status == PresentationStatus.CaptureInProgress ) 
		{
			this.Debug("Loading Video after change in status");
			this.LoadVideo(0, false);
		}
		
		if (this.PlayFrom != -1)
		{
			this.SetPlayFrom(this.PlayFrom);
		}
		
		
		this.IsSetupComplete = true;
	}
	
	this.SetPlayFrom = function(playFrom)
	{
		this.Debug("SetPlayFrom(): " + playFrom);
		
		var macPlayerFrame = frames["FrameMacPlayer"];
		if (!macPlayerFrame)
		{
			SfDebug.DPF(SfDebug.ErrMsgCritical, "Could not find Mac frame");
			return;
		}

		var	playerFrameSrc = Util.GetDocumentBase() + "/Mac/FrameMacPlayer.aspx?" +
			SfRequestVariables.PresentationID + "=" + MainHelper.Presentation.PresentationID +
			"&" + SfRequestVariables.PlayFrom + "=" + playFrom + 
			"&" + SfRequestVariables.ViewerMode + "=Default";

		this.Debug("Loading: " + playerFrameSrc);
		macPlayerFrame.location = playerFrameSrc;
		
		var slideNumber = this.CalculateSlideNumberToShow(playFrom/1000);
		
		if (slideNumber == 0)
		{
			this.Debug("no need to change slide");
			return;
		}
		
		this.Debug("switching to slide: " + slideNumber);
		var args =  MainHelper.CreateShowSlideEventArgs(slideNumber);
		MainHelper.EventScript.Post(args);	
	}

	this.OnUnLoad = function()
	{
		if (this.evScriptHandler)
		{
		    if (MainHelper && MainHelper.EventScript)
		    {
			    MainHelper.EventScript.RemoveHandler(this.evScriptHandler);
			}
		}
		this.evScriptHandler=null;
		if (this.evCommandHandler)
		{
		    if (MainHelper && MainHelper.EventCommand)
		    {
			    MainHelper.EventCommand.RemoveHandler(this.evCommandHandler);
			}
		}
		this.evCommandHandler=null;
    }

	this.LoadVideo = function(slideNumber, endVideo)
	{
		this.Debug("load video called, slideNumber: " + slideNumber);

		var macPlayerFrame = frames["FrameMacPlayer"];
		if (!macPlayerFrame)
		{
			SfDebug.DPF(SfDebug.ErrMsgCritical, "Could not find Mac frame");
			return;
		}

		var playerFrameSrc = Util.GetDocumentBase() + "Mac/FrameMacPlayer.aspx?" +
				SfRequestVariables.PresentationID + "=" + MainHelper.Presentation.PresentationID +
				"&" + SfRequestVariables.SlideNumber + "=" + slideNumber + 
				"&" + SfRequestVariables.EndVideo + "=" + endVideo +
				"&" + SfRequestVariables.ViewerMode + "=Default";

		this.Debug("Loading: " + playerFrameSrc);
		macPlayerFrame.location = playerFrameSrc;
	}

	this.LocalOnScriptEvent = function(args)
	{
		switch(args.Command)
		{
			case SfScriptCommandType.EndPresentation:
				MainHelper.PresentationEnded = true;

				if ( MainHelper.Presentation.Status == PresentationStatus.CaptureInProgress ) 
				{
					// only force reload with no URL for live, otherwise just let it play out to the end.
					this.LoadVideo(0, true);
				}
				MainHelper.CurrentSlideNumber = MainHelper.MaxSlideTimings;
				break;
		}
	}

	this.LocalOnCommandEvent = function(args)
	{
		switch(args.Command)
		{
			case SfCommandType.NavigateToSlide:
				var slideNumber = args.SlideNumber;
				if (!slideNumber)
				{
					SfDebug.DPF(SfDebug.ErrMsgCritical, "Navigate to Slide no SlideNumber present");
					return;
				}
				this.NavigateToSlide(Number(slideNumber));
				break;
		}
	}
	
	this.NavigateToSlide = function(slideNumber)
	{
		this.Debug("NavigateToSlide with slideNumber: " + slideNumber + " called");
		
		if (MainHelper.Presentation.Status != PresentationStatus.ReplayReady)
		{
			this.Debug("can not navigate when presentation is not on demand");
			return;
		}
		
		if (slideNumber < 0)
		{
			this.Debug("SlideNumber is less than 0");
			return;
		}
		if (MainHelper.MaxSlideTimings < slideNumber)
		{
			SfDebug.DPF(SfDebug.ErrMsgCritical, "slidetimings not known for slideNumber: " + slideNumber);
			return;
		}
		
		this.LoadVideo(slideNumber, false);
		
		// event is not automatically getting fired
		// so do it manually
		var args = MainHelper.CreateShowSlideEventArgs(slideNumber);
		this.ScriptParser.NotifyScriptEvent(args);
		
		MainHelper.PresentationEnded = false;
		
		MainHelper.EventCommand.Post(new CommandArgs(SfCommandType.ShowSlideShow));
	}
}
